/**
 * Triggered when a click happens on a page plus or minus sign
 * @param my - refers to the element being clicked
 */
function levelToggle(my,options)
{
	var parent = $(my);
	var level = $(my).attr('wpoLevel');
	var parentNumber = $(my).attr('wpoNumber');
	var openStatus = $(my).attr('wpoOpenStatus');
	var containerLi = $(my).parents('.pageItem');
	var childs = $(containerLi[0]).children('ul');
	if (openStatus < 0) { //ajax hasn't loaded this item
		var ajax = $.ajax({
			type: "POST",
			url: options.url,
			data: "level=" + level + "&parentNumber=" + parentNumber,
			async: false
		});
		$(containerLi[0]).append(ajax.responseText);
		childs = $(containerLi[0]).children('ul');
		//$(childs[0]).show();
		$(childs[0]).slideDown('normal');
		parent.attr('wpoOpenStatus',1);
	} else if (openStatus == 0) { //closed by hidden
		parent.attr('wpoOpenStatus',1);
		//$(childs[0]).show();
		$(childs[0]).slideDown('normal');
	} else { //opened
		parent.attr('wpoOpenStatus',0);
		//$(childs[0]).hide();
		$(childs[0]).slideUp('normal');
	}
	toggleLevelImage(level);
}

/**
 * Triggered when a click happens on a page plus or minus sign for page access groups
 * @param my - refers to the element being clicked
 */
function adminLevelToggle(my, cascadeIdName, options)
{
	var parent = $(my);
	var level = $(my).attr('wpoLevel');
	var doCascade = 0;
	if (cascadeIdName != null) {
		var cascade = document.getElementById(cascadeIdName);
		if (cascade) {
			if (cascade.checked) {
				doCascade = 1;
			}
		}
	}
	var toggle = $('#selectedpage_'+level+'_').val();
	var parentNumber = $(my).attr('wpoNumber');
	var openStatus = $(my).attr('wpoOpenStatus');
	var containerLi = $(my).parents('.adminPageItemResource');
	var childs = $(containerLi[0]).children('ul');
	if (openStatus < 0) { //ajax hasn't loaded this item
		var ajax = $.ajax({
			type: "POST",
			url: options.url,
			data: "level=" + level + "&parentNumber=" + parentNumber + "&toggle=" + toggle + "&cascade=" + doCascade + "&group_id=" + options.group_id,
			async: false
		});
		$(containerLi[0]).append(ajax.responseText);
		childs = $(containerLi[0]).children('ul');
		//$(childs[0]).show();
		$(childs[0]).slideDown('normal');
		parent.attr('wpoOpenStatus',1);
	} else if (openStatus == 0) { //closed by hidden
		parent.attr('wpoOpenStatus',1);
		//$(childs[0]).show();
		$(childs[0]).slideDown('normal');
	} else { //opened
		parent.attr('wpoOpenStatus',0);
		//$(childs[0]).hide();
		$(childs[0]).slideUp('normal');
	}
	toggleLevelImage(level);
}

/**
 * Changes the class of the plus/minus image when someone clicks on one
 */
function toggleLevelImage(id) {
	var ele = $('#level_toggle_' + id);
	var class2 = ele.attr('class');
	if (class2 == 'level_open') {
		ele.attr('class','level_closed');
	} else {
		ele.attr('class','level_open');
	}
}

function toggleTab(def,instance,onTab) {
	var oldtab = '';
	if(!window.tabs) {
		window.tabs = [];
		window.tabs[instance] = onTab;
		oldtab = def;
	} else {
		if (!window.tabs[instance]) {
			window.tabs[instance] = onTab;
			oldtab = def;
		} else {
			oldtab = window.tabs[instance];
			window.tabs[instance] = onTab;
		}
	}
	document.getElementById(oldtab).className = 'off';
	document.getElementById(onTab).className = 'on';
}

function togglePanel(def,instance,onPanel) {
	var oldpanel = '';
	if (!window.panels) {
		window.panels = [];
		window.panels[instance] = onPanel;
		oldpanel = def;
	} else {
		if (!window.panels[instance]) {
			window.panels[instance] = onPanel;
			oldpanel = def;
		} else {
			oldpanel = window.panels[instance];
			window.panels[instance] = onPanel;
		}
	}
	document.getElementById(oldpanel).style.display = 'none';
	document.getElementById(onPanel).style.display = 'block';
}


        	    function goTo(url){
                	window.location.href = url;
       	   	 }
        	  
  function toggle_hover(li){
								var ulchilds = li.getElementsByTagName('UL');
        				if (ulchilds.length) {
                	ulchilds[0].style.display = ulchilds[0].style.display == 'block' ? 'none' : 'block';
        				}
       	   	 }

        		function showPane(id1,id2){
                		var ele1 = document.getElementById(id1);
                		var ele2 = document.getElementById(id2);
                		ele1.style.display="block";
                		ele2.style.display="none";
				return false;
        		}

	
        	function toggleall(id,span){
			var ele = document.getElementById(id);
			if (ele.style.display=="none") {
				ele.style.display="block";
				document.getElementById(span).setAttribute("src", "images1/icon_minus.gif");
			} else {
				ele.style.display="none";
				document.getElementById(span).setAttribute("src", "images1/icon_plus.gif");
			}
        	}


        	function showuser(){
			var ele = document.getElementById('p1');
			if (document.usereditor.access_type.options[document.usereditor.access_type.selectedIndex].value=="user") 
				ele.style.display="block";
			else
				ele.style.display="none";
   }
	

function updateoption(){
var tb = document.getElementById('bottom');
var boxLength = tb.length;
var selectedItem = tb.selectedIndex;
var i;

tb.options[selectedItem] = null;
for (i = 0; i < boxLength; i++){ 
	if(tb.options[i])
 		tb.options[i].selected=true;} 
}

function appear(t,ele){
	document.getElementById(ele).style.display = t.checked ? "block" : "none"; 
}

function toggleElement(tagset,activetab) {

var tabs=document.getElementById(tagset).getElementsByTagName('li');
for (var i=0; i<tabs.length; i++) {
          if (tabs[i].id=='tab_' + activetab) {
                 tabs[i].className='on';
                 document.getElementById('panel_tab_' + activetab).style.display='block';
         }  
          else {
           document.getElementById('panel_' + tabs[i].id ).style.display='none';
           tabs[i].className='off';
         }
}

}


function toggle_tab2(def,instance,onTab) {
	var oldtab = '';
	if(!window.tabs) {
		window.tabs = [];
		window.tabs[instance] = onTab;
		oldtab = def;
	} else {
		if (!window.tabs[instance]) {
			window.tabs[instance] = onTab;
			oldtab = def;
		} else {
			oldtab = window.tabs[instance];
			window.tabs[instance] = onTab;
		}
	}
	document.getElementById(oldtab).className = '';
	document.getElementById(onTab).className = 'on';
}

function toggle_panel2(def,instance,onPanel) {
	var oldpanel = '';
	if (!window.panels) {
		window.panels = [];
		window.panels[instance] = onPanel;
		oldpanel = def;
	} else {
		if (!window.panels[instance]) {
			window.panels[instance] = onPanel;
			oldpanel = def;
		} else {
			oldpanel = window.panels[instance];
			window.panels[instance] = onPanel;
		}
	}
	document.getElementById(oldpanel).style.display = 'none';
	document.getElementById(onPanel).style.display = 'block';
}

var isChanged=false;
var isIE=(navigator.userAgent.indexOf('MSIE')>=0);

function load_function(){   //overwritten from destlist.php 
setEvents();

}

function checkForChange(evt){

if (isChanged && !confirm("Page has been changed \'Press Cancel\' and \'Update\' to save changes. Pressing Okay will discard changes.")){
if(isIE) {
 window.event.cancelBubble = true;
window.event.returnValue=false;
}
 else {
 evt.preventDefault();
 evt.returnValue=false;
}
}
}

function updateMade(){
isChanged=true;
}


function checkForReturn(evt){
if(isIE) {
if (window.event.keyCode==13){
 window.event.cancelBubble = true;
window.event.returnValue=false;
}
}
 else {
if (evt.keyCode==13){
 evt.preventDefault();
 evt.returnValue=false;
}

}
}
 
function  setEvents(){
for (var i=0; i< document.links.length; i++)
if (document.links[i].target!='_blank')
if (isIE) document.links[i].attachEvent("onclick",checkForChange);
else  document.links[i].addEventListener("click",checkForChange,false);

for (i=0; i< document.forms.length; i++){
for (var j=0; j< document.forms[i].elements.length; j++){
if(isIE) document.forms[i].elements[j].attachEvent("onchange", updateMade);
  else document.forms[i].elements[j].addEventListener("change",updateMade,false);
 if (document.forms[i].elements[j].type=='text'){
     if(isIE) document.forms[i].elements[j].attachEvent("onkeypress", checkForReturn);
         else document.forms[i].elements[j].addEventListener("keypress",checkForReturn,false);
}
}
}
}


function pagePermissionClick(my,form,level,id) {

	var _hiddenID = "page_per_" + level + "_" + id;
	var _hiddenEle = document.getElementById(_hiddenID);
	var _ulID = "ul_" + id;
	var _ulEle = document.getElementById(_ulID);
	var _ulDivChilds = null;
	var _ulHiddenChilds = null;
	
	if (_ulEle) {
		_ulDivChilds = _ulEle.getElementsByTagName("div");
		_ulHiddenChilds = _ulEle.getElementsByTagName('input');
	}

	my.className = my.className == 'selected' ? '' : 'selected';
	_hiddenEle.value = _hiddenEle.value == 0 ? 1 : 0;

	if (_ulDivChilds && _ulDivChilds.length) {
		for (var j = 0; j < _ulDivChilds.length; j++) {
			_ulDivChilds[j].className = my.className;
		}
	}

	if (_ulHiddenChilds && _ulHiddenChilds.length) {
		for (var j = 0; j < _ulHiddenChilds.length; j++) {
			if (_ulHiddenChilds[j].type=="hidden") {
				_ulHiddenChilds[j].value = Number(_hiddenEle.value);
			}
		}
	}	
}

function pagePermissionToggleAll(s) {
	
	var _ulID = "ul_0";
	var _ulEle = document.getElementById(_ulID);
	var _ulDivChilds = null
	var _ulHiddenChilds = null;
	var _selected = s == 1 ? "selected" : "";
	var _checked = s == 1 ? 1 : 0;

	if (_ulEle) {
		_ulDivChilds = _ulEle.getElementsByTagName('div');
		_ulHiddenChilds = _ulEle.getElementsByTagName('input');
	}

	if (_ulDivChilds && _ulDivChilds.length) {
		for (var j = 0; j < _ulDivChilds.length; j++) {
			if (_ulDivChilds[j].id.substring(0,3) == 'li_') {
				_ulDivChilds[j].className = _selected;
			}
		}
	}

	if (_ulHiddenChilds && _ulHiddenChilds.length) {
		for (var j = 0; j < _ulHiddenChilds.length; j++) {
			if (_ulHiddenChilds[j].type == "hidden" && _ulHiddenChilds[j].id.substring(0,9) == "page_per_") {
				_ulHiddenChilds[j].value = _checked;
			}
		}
	}
}
