/*--------------------------------------------
CALENDAR DATE PICKER
----------------------------------------------*/
// Title: Timestamp picker
// Description: See the demo at url
// URL: http://us.geocities.com/tspicker/
// Script featured on: http://javascriptkit.com/script/script2/timestamp.shtml
// Version: 1.0
// Date: 12-05-2001 (mm-dd-yyyy)
// Author: Denis Gritcyuk <denis@softcomplex.com>; <tspicker@yahoo.com>
// Notes: Permission given to use this script in any kind of applications if
//    header lines are left unchanged. Feel free to contact the author
//    for feature requests and/or donations

function return_calendar_date(ele_id,val) {
	var ele = document.getElementById(ele_id);
	ele.value = val;
}
//function show_calendar(str_target, str_datetime) {
function show_calendar(ele_id,str_datetime) {
	var arr_months = ["January", "February", "March", "April", "May", "June",
		"July", "August", "September", "October", "November", "December"];
	var week_days = ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"];
	var n_weekstart = 0; // day week starts from (normally 0 or 1)
	
	var ele = document.getElementById(ele_id);
	
	//var str_datetime = ele.value;

	var dt_datetime = (str_datetime == null || str_datetime =="" ?  new Date() : str2dt(str_datetime));
	var dt_prev_month = new Date(dt_datetime);
	dt_prev_month.setMonth(dt_datetime.getMonth()-1);
	var dt_next_month = new Date(dt_datetime);
	dt_next_month.setMonth(dt_datetime.getMonth()+1);
	if (dt_next_month.getMonth()-dt_datetime.getMonth() > 1) {
		while (dt_next_month.getMonth()-dt_datetime.getMonth() > 1) {
			dt_next_month.setDate(dt_next_month.getDate()-1);
		}
	}
	var dt_prev_year = new Date(dt_datetime);
	dt_prev_year.setYear(dt_datetime.getFullYear()-1);
	var dt_next_year = new Date(dt_datetime);
	dt_next_year.setYear(dt_datetime.getFullYear()+1);
	var dt_firstday = new Date(dt_datetime);
	dt_firstday.setDate(1);
	dt_firstday.setDate(1-(7+dt_firstday.getDay()-n_weekstart)%7);
	var dt_lastday = new Date(dt_next_month);
	dt_lastday.setDate(0);
	
	// html generation (feel free to tune it for your particular application)
	// print calendar header
	var str_buffer = new String (
		"<html>\n"+
		"<head>\n"+
		"	<title>Calendar</title>\n"+
		"<link href='http://demo.biz-zone.com/wpo/css/style_defaultalpha.css' rel='STYLESHEET' type='text/css'>"+
		"</head>\n"+
		"<body><div class=\"date_picker_containter\">\n"+
		"<table class=\"date_picker_table\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\" valign=\"top\">\n"+
		
		"<tr><td>\n"+
		"<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n"+
		"<tr class='months'>"+
		"<td class='month' colspan='4' align='center'><table class='month' width='100%' cellspacing='0' cellpadding='0' border='0'><tr>"+
		"<td align='left'>"+
		"<a href=\"javascript:window.opener.show_calendar('"+ele_id+"', '"+ dt2dtstr(dt_prev_month)+"');\"><img src='/images/btn_arrow_down3.gif' border='0'></a>"+
		"</td><td align='center'>"
		+arr_months[dt_datetime.getMonth()]+
		"</td><td align='right'>"+
		"<a href=\"javascript:window.opener.show_calendar('"+ele_id+"', '"+dt2dtstr(dt_next_month)+"');\"><img src='/images/btn_arrow_up3.gif' border='0'></a>"+
		"</td>"+
		"</tr></table></td><td class='year' colspan='3' align='center'><table class='month' width='100%' cellspacing='0' cellpadding='0' border='0'><tr>"+
		"<td align='left'>"+
		"<a href=\"javascript:window.opener.show_calendar('"+ele_id+"', '"+ dt2dtstr(dt_prev_year)+"');\"><img src='/images/btn_arrow_down3.gif' border='0'></a>"+
		"</td><td align='center'>"
		+dt_datetime.getFullYear()+
		"</td><td align='right'>"+
		"<a href=\"javascript:window.opener.show_calendar('"+ele_id+"', '"+dt2dtstr(dt_next_year)+"');\"><img src='/images/btn_arrow_up3.gif' border='0'></a>"+
		"</td>"+
		"</tr></table></td>\n</tr>\n"
	);

	var dt_current_day = new Date(dt_firstday);
	// print weekdays titles
	str_buffer += "<tr>\n";
	for (var n=0; n<7; n++)
		str_buffer += "	<td class='weekdays'>"+
		""+
		week_days[(n_weekstart+n)%7]+"</td>\n";
	// print calendar table
	str_buffer += "</tr>\n";
	var tr_count = 1;
	//while (dt_current_day.getMonth() == dt_datetime.getMonth() || dt_current_day.getMonth() == dt_firstday.getMonth()) {
	while (tr_count < 7) {
		// print row heder
		str_buffer += "<tr>\n";
		for (var n_current_wday=0; n_current_wday<7; n_current_wday++) {
			var ap_class = "";
			if (dt_current_day.getMonth() != dt_datetime.getMonth()) {
				ap_class = "_other_month";
			}
				if (dt_current_day.getDate() == dt_datetime.getDate() &&
					dt_current_day.getMonth() == dt_datetime.getMonth())
					// print current date
					str_buffer += "	<td class='selected' align=\"right\">";
				else if (dt_current_day.getDay() == 0 || dt_current_day.getDay() == 6)
					// weekend days
					str_buffer += "	<td class='weekend"+ap_class+"' align=\"right\">";
				else
					// print working days of current month
					str_buffer += "	<td class='working"+ap_class+"' align=\"right\">";

				if (dt_current_day.getMonth() == dt_datetime.getMonth())
					// print days of current month
					str_buffer += "<a href=\"javascript:window.opener.return_calendar_date('"+ele_id+"','"+dt2dtstr(dt_current_day)+"'); window.close();\">";
				else 
					// print days of other months
					str_buffer += "<a class='other' href=\"javascript:window.opener.return_calendar_date('"+ele_id+"','"+dt2dtstr(dt_current_day)+"'); window.close();\">";
					
				str_buffer += dt_current_day.getDate()+"</a></td>\n";
				dt_current_day.setDate(dt_current_day.getDate()+1);
		}
		// print row footer
		str_buffer += "</tr>\n";
		tr_count++;
	}
	// print calendar footer
	str_buffer +=
		"</table>\n" +
		"</tr>\n</td>\n</table>\n" +
		"</div></body>\n" +
		"</html>\n";

	var vWinCal = window.open("", "Calendar",
	"width=300,height=215,status=no,resizable=yes,top=0,left=0");
	vWinCal.opener = self;
	var calc_doc = vWinCal.document;
	calc_doc.write (str_buffer);
	calc_doc.close();
}


// datetime parsing and formatting routimes. modify them if you wish other datetime format
function str2dt (str_datetime) {
	//var re_date = /^(\d+)\-(\d+)\-(\d+)\s+(\d+)\:(\d+)\:(\d+)$/;
	//if (!re_date.exec(str_datetime)) {
		var re_date2 = /^(\d+)\-(\d+)\-(\d+)/;
		if (!re_date2.exec(str_datetime)) {
			return alert("Invalid Datetime format: "+ str_datetime);
		} else {
			return (new Date (RegExp.$1, RegExp.$2-1, RegExp.$3));
		}
	//} else {
		//return (new Date (RegExp.$3, RegExp.$2-1, RegExp.$1, RegExp.$4, RegExp.$5, RegExp.$6));
	//}
	//return ;
}
function dt2dtstr (dt_datetime) {
	var month = dt_datetime.getMonth()+1;
	month = month < 10 ? "0"+month : month;
	
	var day = dt_datetime.getDate();
	day = day < 10 ? "0"+day : day;
	return (new String (
			//dt_datetime.getDate()+"-"+(dt_datetime.getMonth()+1)+"-"+dt_datetime.getFullYear()+""
			dt_datetime.getFullYear()+"-"+(month)+"-"+day
			)
			);
}

function dt2tmstr (dt_datetime) {
	return (new String (" "+
			dt_datetime.getHours()+":"+dt_datetime.getMinutes()+":"+dt_datetime.getSeconds()));
}


function modal_dialog(url,name,arg,width,height) {
	return window.open(url,name,"width="+width+",height="+height+",top=200,left=200,toolbar=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=no,modal=yes");
}

