jQuery.fn.toggleToggle = function(options) 
{
	this.each(function(index, toggle) {
		jQuery.replaceToggle(toggle, options);
	});
};

jQuery.replaceToggle = function(toggle, options) 
{
	name = toggle.name;
	id = name.replace(/[\[\]]/g,'_');
	checked = toggle.checked;
	
	var span = jQuery(document.createElement('span'));
	span.addClass('toggled');
	if (checked) {
		var img = jQuery(document.createElement('img'));
		img.attr('src',options.url + options.imgOn);
		img.attr('id','img_' + id);
		img.bind('click', function(e) {
				jQuery.toggleToggleImg(this,options);
		});
		var input = jQuery(document.createElement('input'));
		input.attr('id', id);
		input.attr('type','hidden');
		input.attr('name',name);
		input.attr('value',1);
		span.append(img);
		span.append(input);
		//jQuery(toggle).replaceWith('<span class="toggled"><img src="/images/toggle_on.gif" onclick="jQuery.toggleToggle(this,\''+id+'\',\''+options.cascadingIdName+'\');"><input id="'+id+'" type="hidden" name="'+name+'" value="1"></span>');
		jQuery(toggle).replaceWith(span);
	} else {
		var img = jQuery(document.createElement('img'));
		img.attr('src',options.url + options.imgOff);
		img.attr('id','img_' + id);
		img.bind('click', function(e) {
				jQuery.toggleToggleImg(this,options);
		});
		var input = jQuery(document.createElement('input'));
		input.attr('id', id);
		input.attr('type','hidden');
		input.attr('name',name);
		input.attr('value',0);
		span.append(img);
		span.append(input);
		//jQuery(toggle).replaceWith('<span class="toggled"><img src="/images/toggle_off.gif" onclick="jQuery.toggleToggle(this,\''+id+'\',\''+options.cascadingIdName+'\');"><input id="'+id+'" type="hidden" name="'+name+'" value="0" class="toggled"></span>');
		jQuery(toggle).replaceWith(span);
	}
};

jQuery.toggleToggleImg = function (imgEle, options)
{
	var toggle = jQuery(imgEle);
	var span = toggle.parent('span');
	
	var hidden = span.find('input:hidden');

	tmp = toggle.attr('src').toString().split('/');
	
	if (hidden.val() == 1) {
		toggle.attr('src',options.url + options.imgOff);
		hidden.val(0);
	} else {
		toggle.attr('src',options.url + options.imgOn);
		hidden.val(1);
	}
	
	if (options.cascadeId != null) {
		var cascade = jQuery('#' + options.cascadeId);
		if (cascade) {
			if (cascade.attr('checked')) {
				jQuery.cascadeToggle(toggle, options);
			}
		}
	}
}


jQuery.cascadeToggle = function(parentToggle, options) 
{
	var parentLi = jQuery(parentToggle).closest('li');
	var parentImg = null;
	var parentHidden = null;
	var imgs = [];
	var hiddens = [];
	
	jQuery(parentLi).find('.toggled img').each(function(index, ele) {
			if (index == 0) {
				parentImg = ele;
			} else {
				imgs[index] = ele;
			}
	});
	
	jQuery(parentLi).find('.toggled input:hidden').each(function(index, ele) {
			if (index == 0) {
				parentHidden = ele;
			} else {
				hiddens[index] = ele;
			}
	});
	
	for (var i = 1; i < imgs.length; i++) {
		jQuery.toggleToggleImg(imgs[i], options);
		jQuery.cascadeToggle(jQuery(imgs[i]), options);
	}
}
